<?php
/**
 * @version $Id: helper.php 13 2013-06-26 11:51:08Z szymon $
 * @package DJ-MediaTools
 * @copyright Copyright (C) 2012 DJ-Extensions.com LTD, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 * @developer Szymon Woronowski - szymon.woronowski@design-joomla.eu
 *
 * DJ-MediaTools is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * DJ-MediaTools is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with DJ-MediaTools. If not, see <http://www.gnu.org/licenses/>.
 *
 */

// no direct access
defined('_JEXEC') or die ('Restricted access');

class SlideshowThumbsDJMediatoolsLayoutHelper extends DJMediatoolsLayoutHelper {
	
	public function getParams(&$params) {
		
		$params = parent::getParams($params);
		
		if(!is_numeric($params->get('thumb_width'))) $params->set('thumb_width', 60);
		if(!is_numeric($params->get('thumb_height'))) $params->set('thumb_height', 40);
		
		return $params;
	}
	
	public function getStyleSheetParams(&$params) {
		
		$options = parent::getStyleSheetParams($params);
				
		$options['tw'] = $params->get('thumb_width');
		$options['th'] = $params->get('thumb_height');
		
		return $options;
	}
	
}

