/*
 * jQuery 
 * Iframe Transport 1.8.2
 * File Upload 5.40.1
 * Processing 1.3.0
 * Validation 1.1.2
 * User Interface 9.5.2
 * https://github.com/blueimp/jQuery-File-Upload
 *
 * Copyright 2010, Sebastian Tschan
 * https://blueimp.net
 *
 * Licensed under the MIT license:
 * http://www.opensource.org/licenses/MIT
 */
/* jquery.iframe-transport.js */
(function(a){if(typeof define==="function"&&define.amd){define(["jquery"],a)}else{a(window.jQuery)}}(function(b){var a=0;b.ajaxTransport("iframe",function(d){if(d.async){var c=d.initialIframeSrc||"javascript:false;",f,e,g;return{send:function(h,i){f=b('<form style="display:none;"></form>');f.attr("accept-charset",d.formAcceptCharset);g=/\?/.test(d.url)?"&":"?";if(d.type==="DELETE"){d.url=d.url+g+"_method=DELETE";d.type="POST"}else{if(d.type==="PUT"){d.url=d.url+g+"_method=PUT";d.type="POST"}else{if(d.type==="PATCH"){d.url=d.url+g+"_method=PATCH";d.type="POST"}}}a+=1;e=b('<iframe src="'+c+'" name="iframe-transport-'+a+'"></iframe>').bind("load",function(){var j,k=b.isArray(d.paramName)?d.paramName:[d.paramName];e.unbind("load").bind("load",function(){var l;try{l=e.contents();if(!l.length||!l[0].firstChild){throw new Error()}}catch(m){l=undefined}i(200,"success",{iframe:l});b('<iframe src="'+c+'"></iframe>').appendTo(f);window.setTimeout(function(){f.remove()},0)});f.prop("target",e.prop("name")).prop("action",d.url).prop("method",d.type);if(d.formData){b.each(d.formData,function(l,m){b('<input type="hidden"/>').prop("name",m.name).val(m.value).appendTo(f)})}if(d.fileInput&&d.fileInput.length&&d.type==="POST"){j=d.fileInput.clone();d.fileInput.after(function(l){return j[l]});if(d.paramName){d.fileInput.each(function(l){b(this).prop("name",k[l]||d.paramName)})}f.append(d.fileInput).prop("enctype","multipart/form-data").prop("encoding","multipart/form-data");d.fileInput.removeAttr("form")}f.submit();if(j&&j.length){d.fileInput.each(function(m,l){var n=b(j[m]);b(l).prop("name",n.prop("name")).attr("form",n.attr("form"));n.replaceWith(l)})}});f.append(e).appendTo(document.body)},abort:function(){if(e){e.unbind("load").prop("src",c)}if(f){f.remove()}}}}});b.ajaxSetup({converters:{"iframe text":function(c){return c&&b(c[0].body).text()},"iframe json":function(c){return c&&b.parseJSON(b(c[0].body).text())},"iframe html":function(c){return c&&b(c[0].body).html()},"iframe xml":function(c){var d=c&&c[0];return d&&b.isXMLDoc(d)?d:b.parseXML((d.XMLDocument&&d.XMLDocument.xml)||b(d.body).html())},"iframe script":function(c){return c&&b.globalEval(b(c[0].body).text())}}})}));
/* jquery.fileupload.js */
(function(a){if(typeof define==="function"&&define.amd){define(["jquery","jquery.ui.widget"],a)}else{a(window.jQuery)}}(function(a){a.support.fileInput=!(new RegExp("(Android (1\\.[0156]|2\\.[01]))|(Windows Phone (OS 7|8\\.0))|(XBLWP)|(ZuneWP)|(WPDesktop)|(w(eb)?OSBrowser)|(webOS)|(Kindle/(1\\.0|2\\.[05]|3\\.0))").test(window.navigator.userAgent)||a('<input type="file">').prop("disabled"));a.support.xhrFileUpload=!!(window.ProgressEvent&&window.FileReader);a.support.xhrFormDataFileUpload=!!window.FormData;a.support.blobSlice=window.Blob&&(Blob.prototype.slice||Blob.prototype.webkitSlice||Blob.prototype.mozSlice);a.widget("blueimp.fileupload",{options:{dropZone:a(document),pasteZone:a(document),fileInput:undefined,replaceFileInput:true,paramName:undefined,singleFileUploads:true,limitMultiFileUploads:undefined,limitMultiFileUploadSize:undefined,limitMultiFileUploadSizeOverhead:512,sequentialUploads:false,limitConcurrentUploads:undefined,forceIframeTransport:false,redirect:undefined,redirectParamName:undefined,postMessage:undefined,multipart:true,maxChunkSize:undefined,uploadedBytes:undefined,recalculateProgress:true,progressInterval:100,bitrateInterval:500,autoUpload:true,messages:{uploadedBytes:"Uploaded bytes exceed file size"},i18n:function(c,b){c=this.messages[c]||c.toString();if(b){a.each(b,function(d,e){c=c.replace("{"+d+"}",e)})}return c},formData:function(b){return b.serializeArray()},add:function(c,b){if(c.isDefaultPrevented()){return false}if(b.autoUpload||(b.autoUpload!==false&&a(this).fileupload("option","autoUpload"))){b.process().done(function(){b.submit()})}},processData:false,contentType:false,cache:false},_specialOptions:["fileInput","dropZone","pasteZone","multipart","forceIframeTransport"],_blobSlice:a.support.blobSlice&&function(){var b=this.slice||this.webkitSlice||this.mozSlice;return b.apply(this,arguments)},_BitrateTimer:function(){this.timestamp=((Date.now)?Date.now():(new Date()).getTime());this.loaded=0;this.bitrate=0;this.getBitrate=function(d,c,b){var e=d-this.timestamp;if(!this.bitrate||!b||e>b){this.bitrate=(c-this.loaded)*(1000/e)*8;this.loaded=c;this.timestamp=d}return this.bitrate}},_isXHRUpload:function(b){return !b.forceIframeTransport&&((!b.multipart&&a.support.xhrFileUpload)||a.support.xhrFormDataFileUpload)},_getFormData:function(b){var c;if(a.type(b.formData)==="function"){return b.formData(b.form)}if(a.isArray(b.formData)){return b.formData}if(a.type(b.formData)==="object"){c=[];a.each(b.formData,function(d,e){c.push({name:d,value:e})});return c}return[]},_getTotal:function(c){var b=0;a.each(c,function(d,e){b+=e.size||1});return b},_initProgressObject:function(c){var b={loaded:0,total:0,bitrate:0};if(c._progress){a.extend(c._progress,b)}else{c._progress=b}},_initResponseObject:function(b){var c;if(b._response){for(c in b._response){if(b._response.hasOwnProperty(c)){delete b._response[c]}}}else{b._response={}}},_onProgress:function(f,d){if(f.lengthComputable){var c=((Date.now)?Date.now():(new Date()).getTime()),b;if(d._time&&d.progressInterval&&(c-d._time<d.progressInterval)&&f.loaded!==f.total){return}d._time=c;b=Math.floor(f.loaded/f.total*(d.chunkSize||d._progress.total))+(d.uploadedBytes||0);this._progress.loaded+=(b-d._progress.loaded);this._progress.bitrate=this._bitrateTimer.getBitrate(c,this._progress.loaded,d.bitrateInterval);d._progress.loaded=d.loaded=b;d._progress.bitrate=d.bitrate=d._bitrateTimer.getBitrate(c,b,d.bitrateInterval);this._trigger("progress",a.Event("progress",{delegatedEvent:f}),d);this._trigger("progressall",a.Event("progressall",{delegatedEvent:f}),this._progress)}},_initProgressListener:function(b){var c=this,d=b.xhr?b.xhr():a.ajaxSettings.xhr();if(d.upload){a(d.upload).bind("progress",function(f){var g=f.originalEvent;f.lengthComputable=g.lengthComputable;f.loaded=g.loaded;f.total=g.total;c._onProgress(f,b)});b.xhr=function(){return d}}},_isInstanceOf:function(b,c){return Object.prototype.toString.call(c)==="[object "+b+"]"},_initXHRData:function(c){var e=this,g,d=c.files[0],b=c.multipart||!a.support.xhrFileUpload,f=a.type(c.paramName)==="array"?c.paramName[0]:c.paramName;c.headers=a.extend({},c.headers);if(c.contentRange){c.headers["Content-Range"]=c.contentRange}if(!b||c.blob||!this._isInstanceOf("File",d)){c.headers["Content-Disposition"]='attachment; filename="'+encodeURI(d.name)+'"'}if(!b){c.contentType=d.type||"application/octet-stream";c.data=c.blob||d}else{if(a.support.xhrFormDataFileUpload){if(c.postMessage){g=this._getFormData(c);if(c.blob){g.push({name:f,value:c.blob})}else{a.each(c.files,function(h,i){g.push({name:(a.type(c.paramName)==="array"&&c.paramName[h])||f,value:i})})}}else{if(e._isInstanceOf("FormData",c.formData)){g=c.formData}else{g=new FormData();a.each(this._getFormData(c),function(h,i){g.append(i.name,i.value)})}if(c.blob){g.append(f,c.blob,d.name)}else{a.each(c.files,function(h,i){if(e._isInstanceOf("File",i)||e._isInstanceOf("Blob",i)){g.append((a.type(c.paramName)==="array"&&c.paramName[h])||f,i,i.uploadName||i.name)}})}}c.data=g}}c.blob=null},_initIframeSettings:function(b){var c=a("<a></a>").prop("href",b.url).prop("host");b.dataType="iframe "+(b.dataType||"");b.formData=this._getFormData(b);if(b.redirect&&c&&c!==location.host){b.formData.push({name:b.redirectParamName||"redirect",value:b.redirect})}},_initDataSettings:function(b){if(this._isXHRUpload(b)){if(!this._chunkedUpload(b,true)){if(!b.data){this._initXHRData(b)}this._initProgressListener(b)}if(b.postMessage){b.dataType="postmessage "+(b.dataType||"")}}else{this._initIframeSettings(b)}},_getParamName:function(b){var c=a(b.fileInput),d=b.paramName;if(!d){d=[];c.each(function(){var e=a(this),f=e.prop("name")||"files[]",g=(e.prop("files")||[1]).length;while(g){d.push(f);g-=1}});if(!d.length){d=[c.prop("name")||"files[]"]}}else{if(!a.isArray(d)){d=[d]}}return d},_initFormSettings:function(b){if(!b.form||!b.form.length){b.form=a(b.fileInput.prop("form"));if(!b.form.length){b.form=a(this.options.fileInput.prop("form"))}}b.paramName=this._getParamName(b);if(!b.url){b.url=b.form.prop("action")||location.href}b.type=(b.type||(a.type(b.form.prop("method"))==="string"&&b.form.prop("method"))||"").toUpperCase();if(b.type!=="POST"&&b.type!=="PUT"&&b.type!=="PATCH"){b.type="POST"}if(!b.formAcceptCharset){b.formAcceptCharset=b.form.attr("accept-charset")}},_getAJAXSettings:function(c){var b=a.extend({},this.options,c);this._initFormSettings(b);this._initDataSettings(b);return b},_getDeferredState:function(b){if(b.state){return b.state()}if(b.isResolved()){return"resolved"}if(b.isRejected()){return"rejected"}return"pending"},_enhancePromise:function(b){b.success=b.done;b.error=b.fail;b.complete=b.always;return b},_getXHRPromise:function(e,d,c){var b=a.Deferred(),f=b.promise();d=d||this.options.context||f;if(e===true){b.resolveWith(d,c)}else{if(e===false){b.rejectWith(d,c)}}f.abort=b.promise;return this._enhancePromise(f)},_addConvenienceMethods:function(f,d){var c=this,b=function(e){return a.Deferred().resolveWith(c,e).promise()};d.process=function(g,e){if(g||e){d._processQueue=this._processQueue=(this._processQueue||b([this])).pipe(function(){if(d.errorThrown){return a.Deferred().rejectWith(c,[d]).promise()}return b(arguments)}).pipe(g,e)}return this._processQueue||b([this])};d.submit=function(){if(this.state()!=="pending"){d.jqXHR=this.jqXHR=(c._trigger("submit",a.Event("submit",{delegatedEvent:f}),this)!==false)&&c._onSend(f,this)}return this.jqXHR||c._getXHRPromise()};d.abort=function(){if(this.jqXHR){return this.jqXHR.abort()}this.errorThrown="abort";c._trigger("fail",null,this);return c._getXHRPromise(false)};d.state=function(){if(this.jqXHR){return c._getDeferredState(this.jqXHR)}if(this._processQueue){return c._getDeferredState(this._processQueue)}};d.processing=function(){return !this.jqXHR&&this._processQueue&&c._getDeferredState(this._processQueue)==="pending"};d.progress=function(){return this._progress};d.response=function(){return this._response}},_getUploadedBytes:function(d){var b=d.getResponseHeader("Range"),e=b&&b.split("-"),c=e&&e.length>1&&parseInt(e[1],10);return c&&c+1},_chunkedUpload:function(m,g){m.uploadedBytes=m.uploadedBytes||0;var f=this,d=m.files[0],e=d.size,b=m.uploadedBytes,c=m.maxChunkSize||e,i=this._blobSlice,j=a.Deferred(),l=j.promise(),h,k;if(!(this._isXHRUpload(m)&&i&&(b||c<e))||m.data){return false}if(g){return true}if(b>=e){d.error=m.i18n("uploadedBytes");return this._getXHRPromise(false,m.context,[null,"error",d.error])}k=function(){var p=a.extend({},m),n=p._progress.loaded;p.blob=i.call(d,b,b+c,d.type);p.chunkSize=p.blob.size;p.contentRange="bytes "+b+"-"+(b+p.chunkSize-1)+"/"+e;f._initXHRData(p);f._initProgressListener(p);h=((f._trigger("chunksend",null,p)!==false&&a.ajax(p))||f._getXHRPromise(false,p.context)).done(function(o,r,q){b=f._getUploadedBytes(q)||(b+p.chunkSize);if(n+p.chunkSize-p._progress.loaded){f._onProgress(a.Event("progress",{lengthComputable:true,loaded:b-p.uploadedBytes,total:b-p.uploadedBytes}),p)}m.uploadedBytes=p.uploadedBytes=b;p.result=o;p.textStatus=r;p.jqXHR=q;f._trigger("chunkdone",null,p);f._trigger("chunkalways",null,p);if(b<e){k()}else{j.resolveWith(p.context,[o,r,q])}}).fail(function(o,r,q){p.jqXHR=o;p.textStatus=r;p.errorThrown=q;f._trigger("chunkfail",null,p);f._trigger("chunkalways",null,p);j.rejectWith(p.context,[o,r,q])})};this._enhancePromise(l);l.abort=function(){return h.abort()};k();return l},_beforeSend:function(c,b){if(this._active===0){this._trigger("start");this._bitrateTimer=new this._BitrateTimer();this._progress.loaded=this._progress.total=0;this._progress.bitrate=0}this._initResponseObject(b);this._initProgressObject(b);b._progress.loaded=b.loaded=b.uploadedBytes||0;b._progress.total=b.total=this._getTotal(b.files)||1;b._progress.bitrate=b.bitrate=0;this._active+=1;this._progress.loaded+=b.loaded;this._progress.total+=b.total},_onDone:function(b,g,f,d){var e=d._progress.total,c=d._response;if(d._progress.loaded<e){this._onProgress(a.Event("progress",{lengthComputable:true,loaded:e,total:e}),d)}c.result=d.result=b;c.textStatus=d.textStatus=g;c.jqXHR=d.jqXHR=f;this._trigger("done",null,d)},_onFail:function(d,f,e,c){var b=c._response;if(c.recalculateProgress){this._progress.loaded-=c._progress.loaded;this._progress.total-=c._progress.total}b.jqXHR=c.jqXHR=d;b.textStatus=c.textStatus=f;b.errorThrown=c.errorThrown=e;this._trigger("fail",null,c)},_onAlways:function(d,e,c,b){this._trigger("always",null,b)},_onSend:function(h,f){if(!f.submit){this._addConvenienceMethods(h,f)}var g=this,j,b,i,c,k=g._getAJAXSettings(f),d=function(){g._sending+=1;k._bitrateTimer=new g._BitrateTimer();j=j||(((b||g._trigger("send",a.Event("send",{delegatedEvent:h}),k)===false)&&g._getXHRPromise(false,k.context,b))||g._chunkedUpload(k)||a.ajax(k)).done(function(e,m,l){g._onDone(e,m,l,k)}).fail(function(e,m,l){g._onFail(e,m,l,k)}).always(function(m,n,l){g._onAlways(m,n,l,k);g._sending-=1;g._active-=1;if(k.limitConcurrentUploads&&k.limitConcurrentUploads>g._sending){var e=g._slots.shift();while(e){if(g._getDeferredState(e)==="pending"){e.resolve();break}e=g._slots.shift()}}if(g._active===0){g._trigger("stop")}});return j};this._beforeSend(h,k);if(this.options.sequentialUploads||(this.options.limitConcurrentUploads&&this.options.limitConcurrentUploads<=this._sending)){if(this.options.limitConcurrentUploads>1){i=a.Deferred();this._slots.push(i);c=i.pipe(d)}else{this._sequence=this._sequence.pipe(d,d);c=this._sequence}c.abort=function(){b=[undefined,"abort","abort"];if(!j){if(i){i.rejectWith(k.context,b)}return d()}return j.abort()};return this._enhancePromise(c)}return d()},_onAdd:function(p,l){var o=this,u=true,t=a.extend({},this.options,l),d=l.files,r=d.length,f=t.limitMultiFileUploads,h=t.limitMultiFileUploadSize,s=t.limitMultiFileUploadSizeOverhead,n=0,m=this._getParamName(t),c,b,q,k,g=0;if(h&&(!r||d[0].size===undefined)){h=undefined}if(!(t.singleFileUploads||f||h)||!this._isXHRUpload(t)){q=[d];c=[m]}else{if(!(t.singleFileUploads||h)&&f){q=[];c=[];for(k=0;k<r;k+=f){q.push(d.slice(k,k+f));b=m.slice(k,k+f);if(!b.length){b=m}c.push(b)}}else{if(!t.singleFileUploads&&h){q=[];c=[];for(k=0;k<r;k=k+1){n+=d[k].size+s;if(k+1===r||((n+d[k+1].size+s)>h)||(f&&k+1-g>=f)){q.push(d.slice(g,k+1));b=m.slice(g,k+1);if(!b.length){b=m}c.push(b);g=k+1;n=0}}}else{c=m}}}l.originalFiles=d;a.each(q||d,function(e,i){var j=a.extend({},l);j.files=q?i:[i];j.paramName=c[e];o._initResponseObject(j);o._initProgressObject(j);o._addConvenienceMethods(p,j);u=o._trigger("add",a.Event("add",{delegatedEvent:p}),j);return u});return u},_replaceFileInput:function(b){var c=b.clone(true);a("<form></form>").append(c)[0].reset();b.after(c).detach();a.cleanData(b.unbind("remove"));this.options.fileInput=this.options.fileInput.map(function(d,e){if(e===b[0]){return c[0]}return e});if(b[0]===this.element[0]){this.element=c}},_handleFileTreeEntry:function(f,g){var e=this,b=a.Deferred(),c=function(h){if(h&&!h.entry){h.entry=f}b.resolve([h])},d;g=g||"";if(f.isFile){if(f._file){f._file.relativePath=g;b.resolve(f._file)}else{f.file(function(h){h.relativePath=g;b.resolve(h)},c)}}else{if(f.isDirectory){d=f.createReader();d.readEntries(function(h){e._handleFileTreeEntries(h,g+f.name+"/").done(function(i){b.resolve(i)}).fail(c)},c)}else{b.resolve([])}}return b.promise()},_handleFileTreeEntries:function(b,d){var c=this;return a.when.apply(a,a.map(b,function(e){return c._handleFileTreeEntry(e,d)})).pipe(function(){return Array.prototype.concat.apply([],arguments)})},_getDroppedFiles:function(c){c=c||{};var b=c.items;if(b&&b.length&&(b[0].webkitGetAsEntry||b[0].getAsEntry)){return this._handleFileTreeEntries(a.map(b,function(e){var d;if(e.webkitGetAsEntry){d=e.webkitGetAsEntry();if(d){d._file=e.getAsFile()}return d}return e.getAsEntry()}))}return a.Deferred().resolve(a.makeArray(c.files)).promise()},_getSingleFileInputFiles:function(d){d=a(d);var b=d.prop("webkitEntries")||d.prop("entries"),c,e;if(b&&b.length){return this._handleFileTreeEntries(b)}c=a.makeArray(d.prop("files"));if(!c.length){e=d.prop("value");if(!e){return a.Deferred().resolve([]).promise()}c=[{name:e.replace(/^.*\\/,"")}]}else{if(c[0].name===undefined&&c[0].fileName){a.each(c,function(f,g){g.name=g.fileName;g.size=g.fileSize})}}return a.Deferred().resolve(c).promise()},_getFileInputFiles:function(b){if(!(b instanceof a)||b.length===1){return this._getSingleFileInputFiles(b)}return a.when.apply(a,a.map(b,this._getSingleFileInputFiles)).pipe(function(){return Array.prototype.concat.apply([],arguments)})},_onChange:function(d){var b=this,c={fileInput:a(d.target),form:a(d.target.form)};this._getFileInputFiles(c.fileInput).always(function(e){c.files=e;if(b.options.replaceFileInput){b._replaceFileInput(c.fileInput)}if(b._trigger("change",a.Event("change",{delegatedEvent:d}),c)!==false){b._onAdd(d,c)}})},_onPaste:function(d){var b=d.originalEvent&&d.originalEvent.clipboardData&&d.originalEvent.clipboardData.items,c={files:[]};if(b&&b.length){a.each(b,function(e,g){var f=g.getAsFile&&g.getAsFile();if(f){c.files.push(f)}});if(this._trigger("paste",a.Event("paste",{delegatedEvent:d}),c)!==false){this._onAdd(d,c)}}},_onDrop:function(f){f.dataTransfer=f.originalEvent&&f.originalEvent.dataTransfer;var b=this,d=f.dataTransfer,c={};if(d&&d.files&&d.files.length){f.preventDefault();this._getDroppedFiles(d).always(function(e){c.files=e;if(b._trigger("drop",a.Event("drop",{delegatedEvent:f}),c)!==false){b._onAdd(f,c)}})}},_onDragOver:function(c){c.dataTransfer=c.originalEvent&&c.originalEvent.dataTransfer;var b=c.dataTransfer;if(b&&a.inArray("Files",b.types)!==-1&&this._trigger("dragover",a.Event("dragover",{delegatedEvent:c}))!==false){c.preventDefault();b.dropEffect="copy"}},_initEventHandlers:function(){if(this._isXHRUpload(this.options)){this._on(this.options.dropZone,{dragover:this._onDragOver,drop:this._onDrop});this._on(this.options.pasteZone,{paste:this._onPaste})}if(a.support.fileInput){this._on(this.options.fileInput,{change:this._onChange})}},_destroyEventHandlers:function(){this._off(this.options.dropZone,"dragover drop");this._off(this.options.pasteZone,"paste");this._off(this.options.fileInput,"change")},_setOption:function(b,c){var d=a.inArray(b,this._specialOptions)!==-1;if(d){this._destroyEventHandlers()}this._super(b,c);if(d){this._initSpecialOptions();this._initEventHandlers()}},_initSpecialOptions:function(){var b=this.options;if(b.fileInput===undefined){b.fileInput=this.element.is('input[type="file"]')?this.element:this.element.find('input[type="file"]')}else{if(!(b.fileInput instanceof a)){b.fileInput=a(b.fileInput)}}if(!(b.dropZone instanceof a)){b.dropZone=a(b.dropZone)}if(!(b.pasteZone instanceof a)){b.pasteZone=a(b.pasteZone)}},_getRegExp:function(d){var c=d.split("/"),b=c.pop();c.shift();return new RegExp(c.join("/"),b)},_isRegExpOption:function(b,c){return b!=="url"&&a.type(c)==="string"&&/^\/.*\/[igm]{0,3}$/.test(c)},_initDataAttributes:function(){var c=this,b=this.options,d=a(this.element[0].cloneNode(false));a.each(d.data(),function(e,f){var g="data-"+e.replace(/([a-z])([A-Z])/g,"$1-$2").toLowerCase();if(d.attr(g)){if(c._isRegExpOption(e,f)){f=c._getRegExp(f)}b[e]=f}})},_create:function(){this._initDataAttributes();this._initSpecialOptions();this._slots=[];this._sequence=this._getXHRPromise(true);this._sending=this._active=0;this._initProgressObject(this);this._initEventHandlers()},active:function(){return this._active},progress:function(){return this._progress},add:function(c){var b=this;if(!c||this.options.disabled){return}if(c.fileInput&&!c.files){this._getFileInputFiles(c.fileInput).always(function(d){c.files=d;b._onAdd(null,c)})}else{c.files=a.makeArray(c.files);this._onAdd(null,c)}},send:function(f){if(f&&!this.options.disabled){if(f.fileInput&&!f.files){var d=this,b=a.Deferred(),g=b.promise(),c,e;g.abort=function(){e=true;if(c){return c.abort()}b.reject(null,"abort","abort");return g};this._getFileInputFiles(f.fileInput).always(function(h){if(e){return}if(!h.length){b.reject();return}f.files=h;c=d._onSend(null,f).then(function(i,k,j){b.resolve(i,k,j)},function(i,k,j){b.reject(i,k,j)})});return this._enhancePromise(g)}f.files=a.makeArray(f.files);if(f.files.length){return this._onSend(null,f)}}return this._getXHRPromise(false,f&&f.context)}})}));
/* jquery.fileupload-process.js */
(function(a){if(typeof define==="function"&&define.amd){define(["jquery","./jquery.fileupload"],a)}else{a(window.jQuery)}}(function(a){var b=a.blueimp.fileupload.prototype.options.add;a.widget("blueimp.fileupload",a.blueimp.fileupload,{options:{processQueue:[],add:function(f,c){var d=a(this);c.process(function(){return d.fileupload("process",c)});b.call(this,f,c)}},processActions:{},_processFile:function(g,f){var e=this,c=a.Deferred().resolveWith(e,[g]),d=c.promise();this._trigger("process",null,g);a.each(g.processQueue,function(h,j){var k=function(i){if(f.errorThrown){return a.Deferred().rejectWith(e,[f]).promise()}return e.processActions[j.action].call(e,i,j)};d=d.pipe(k,j.always&&k)});d.done(function(){e._trigger("processdone",null,g);e._trigger("processalways",null,g)}).fail(function(){e._trigger("processfail",null,g);e._trigger("processalways",null,g)});return d},_transformProcessQueue:function(c){var d=[];a.each(c.processQueue,function(){var e={},g=this.action,f=this.prefix===true?g:this.prefix;a.each(this,function(h,i){if(a.type(i)==="string"&&i.charAt(0)==="@"){e[h]=c[i.slice(1)||(f?f+h.charAt(0).toUpperCase()+h.slice(1):h)]}else{e[h]=i}});d.push(e)});c.processQueue=d},processing:function(){return this._processing},process:function(e){var d=this,c=a.extend({},this.options,e);if(c.processQueue&&c.processQueue.length){this._transformProcessQueue(c);if(this._processing===0){this._trigger("processstart")}a.each(e.files,function(f){var h=f?a.extend({},c):c,g=function(){if(e.errorThrown){return a.Deferred().rejectWith(d,[e]).promise()}return d._processFile(h,e)};h.index=f;d._processing+=1;d._processingQueue=d._processingQueue.pipe(g,g).always(function(){d._processing-=1;if(d._processing===0){d._trigger("processstop")}})})}return this._processingQueue},_create:function(){this._super();this._processing=0;this._processingQueue=a.Deferred().resolveWith(this).promise()}})}));
/* jquery.fileupload-validate.js */
(function(a){if(typeof define==="function"&&define.amd){define(["jquery","./jquery.fileupload-process"],a)}else{a(window.jQuery)}}(function(a){a.blueimp.fileupload.prototype.options.processQueue.push({action:"validate",always:true,acceptFileTypes:"@",maxFileSize:"@",minFileSize:"@",maxNumberOfFiles:"@",disabled:"@disableValidation"});a.widget("blueimp.fileupload",a.blueimp.fileupload,{options:{getNumberOfFiles:a.noop,messages:{maxNumberOfFiles:"Maximum number of files exceeded",acceptFileTypes:"File type not allowed",maxFileSize:"File is too large",minFileSize:"File is too small"}},processActions:{validate:function(g,d){if(d.disabled){return g}var c=a.Deferred(),f=this.options,e=g.files[g.index],b;if(d.minFileSize||d.maxFileSize){b=e.size}if(a.type(d.maxNumberOfFiles)==="number"&&(f.getNumberOfFiles()||0)+g.files.length>d.maxNumberOfFiles){e.error=f.i18n("maxNumberOfFiles")}else{if(d.acceptFileTypes&&!(d.acceptFileTypes.test(e.type)||d.acceptFileTypes.test(e.name))){e.error=f.i18n("acceptFileTypes")}else{if(b>d.maxFileSize){e.error=f.i18n("maxFileSize")}else{if(a.type(b)==="number"&&b<d.minFileSize){e.error=f.i18n("minFileSize")}else{delete e.error}}}}if(e.error||g.files.error){g.files.error=true;c.rejectWith(this,[g])}else{c.resolveWith(this,[g])}return c.promise()}}})}));
/* jquery.fileupload-ui.js */
(function(a){if(typeof define==="function"&&define.amd){define(["jquery","tmpl","./jquery.fileupload-image","./jquery.fileupload-audio","./jquery.fileupload-video","./jquery.fileupload-validate"],a)}else{a(window.jQuery,window.tmpl)}}(function(b,a){b.blueimp.fileupload.prototype._specialOptions.push("filesContainer","uploadTemplateId","downloadTemplateId");b.widget("blueimp.fileupload",b.blueimp.fileupload,{options:{autoUpload:false,uploadTemplateId:"template-upload",downloadTemplateId:"template-download",filesContainer:undefined,prependFiles:false,dataType:"json",getNumberOfFiles:function(){return this.filesContainer.children().not(".processing").length},getFilesFromResponse:function(c){if(c.result&&b.isArray(c.result.files)){return c.result.files}return[]},add:function(h,f){if(h.isDefaultPrevented()){return false}var g=b(this),d=g.data("blueimp-fileupload")||g.data("fileupload"),c=d.options;f.context=d._renderUpload(f.files).data("data",f).addClass("processing");c.filesContainer[c.prependFiles?"prepend":"append"](f.context);d._forceReflow(f.context);d._transition(f.context);f.process(function(){return g.fileupload("process",f)}).always(function(){f.context.each(function(e){b(this).find(".size").text(d._formatFileSize(f.files[e].size))}).removeClass("processing");d._renderPreviews(f)}).done(function(){f.context.find(".start").prop("disabled",false);if((d._trigger("added",h,f)!==false)&&(c.autoUpload||f.autoUpload)&&f.autoUpload!==false){f.submit()}}).fail(function(){if(f.files.error){f.context.each(function(i){var e=f.files[i].error;if(e){b(this).find(".error").text(e)}})}})},send:function(f,d){if(f.isDefaultPrevented()){return false}var c=b(this).data("blueimp-fileupload")||b(this).data("fileupload");if(d.context&&d.dataType&&d.dataType.substr(0,6)==="iframe"){d.context.find(".progress").addClass(!b.support.transition&&"progress-animated").attr("aria-valuenow",100).children().first().css("width","100%")}return c._trigger("sent",f,d)},done:function(j,i){if(j.isDefaultPrevented()){return false}var h=b(this).data("blueimp-fileupload")||b(this).data("fileupload"),d=i.getFilesFromResponse||h.options.getFilesFromResponse,g=d(i),f,c;if(i.context){i.context.each(function(e){var k=g[e]||{error:"Empty file upload result"};c=h._addFinishedDeferreds();h._transition(b(this)).done(function(){var l=b(this);f=h._renderDownload([k]).replaceAll(l);h._forceReflow(f);h._transition(f).done(function(){i.context=b(this);h._trigger("completed",j,i);h._trigger("finished",j,i);c.resolve()})})})}else{f=h._renderDownload(g)[h.options.prependFiles?"prependTo":"appendTo"](h.options.filesContainer);h._forceReflow(f);c=h._addFinishedDeferreds();h._transition(f).done(function(){i.context=b(this);h._trigger("completed",j,i);h._trigger("finished",j,i);c.resolve()})}},fail:function(h,g){if(h.isDefaultPrevented()){return false}var f=b(this).data("blueimp-fileupload")||b(this).data("fileupload"),d,c;if(g.context){g.context.each(function(e){if(g.errorThrown!=="abort"){var i=g.files[e];i.error=i.error||g.errorThrown||true;c=f._addFinishedDeferreds();f._transition(b(this)).done(function(){var j=b(this);d=f._renderDownload([i]).replaceAll(j);f._forceReflow(d);f._transition(d).done(function(){g.context=b(this);f._trigger("failed",h,g);f._trigger("finished",h,g);c.resolve()})})}else{c=f._addFinishedDeferreds();f._transition(b(this)).done(function(){b(this).remove();f._trigger("failed",h,g);f._trigger("finished",h,g);c.resolve()})}})}else{if(g.errorThrown!=="abort"){g.context=f._renderUpload(g.files)[f.options.prependFiles?"prependTo":"appendTo"](f.options.filesContainer).data("data",g);f._forceReflow(g.context);c=f._addFinishedDeferreds();f._transition(g.context).done(function(){g.context=b(this);f._trigger("failed",h,g);f._trigger("finished",h,g);c.resolve()})}else{f._trigger("failed",h,g);f._trigger("finished",h,g);f._addFinishedDeferreds().resolve()}}},progress:function(f,d){if(f.isDefaultPrevented()){return false}var c=Math.floor(d.loaded/d.total*100);if(d.context){d.context.each(function(){b(this).find(".progress").attr("aria-valuenow",c).children().first().css("width",c+"%")})}},progressall:function(h,f){if(h.isDefaultPrevented()){return false}var g=b(this),d=Math.floor(f.loaded/f.total*100),c=g.find(".fileupload-progress"),i=c.find(".progress-extended");if(i.length){i.html((g.data("blueimp-fileupload")||g.data("fileupload"))._renderExtendedProgress(f))}c.find(".progress").attr("aria-valuenow",d).children().first().css("width",d+"%")},start:function(d){if(d.isDefaultPrevented()){return false}var c=b(this).data("blueimp-fileupload")||b(this).data("fileupload");c._resetFinishedDeferreds();c._transition(b(this).find(".fileupload-progress")).done(function(){c._trigger("started",d)})},stop:function(f){if(f.isDefaultPrevented()){return false}var d=b(this).data("blueimp-fileupload")||b(this).data("fileupload"),c=d._addFinishedDeferreds();b.when.apply(b,d._getFinishedDeferreds()).done(function(){d._trigger("stopped",f)});d._transition(b(this).find(".fileupload-progress")).done(function(){b(this).find(".progress").attr("aria-valuenow","0").children().first().css("width","0%");b(this).find(".progress-extended").html("&nbsp;");c.resolve()})},processstart:function(c){if(c.isDefaultPrevented()){return false}b(this).addClass("fileupload-processing")},processstop:function(c){if(c.isDefaultPrevented()){return false}b(this).removeClass("fileupload-processing")},destroy:function(f,d){if(f.isDefaultPrevented()){return false}var c=b(this).data("blueimp-fileupload")||b(this).data("fileupload"),g=function(){c._transition(d.context).done(function(){b(this).remove();c._trigger("destroyed",f,d)})};if(d.url){d.dataType=d.dataType||c.options.dataType;b.ajax(d).done(g).fail(function(){c._trigger("destroyfailed",f,d)})}else{g()}}},_resetFinishedDeferreds:function(){this._finishedUploads=[]},_addFinishedDeferreds:function(c){if(!c){c=b.Deferred()}this._finishedUploads.push(c);return c},_getFinishedDeferreds:function(){return this._finishedUploads},_enableDragToDesktop:function(){var f=b(this),d=f.prop("href"),c=f.prop("download"),e="application/octet-stream";f.bind("dragstart",function(g){try{g.originalEvent.dataTransfer.setData("DownloadURL",[e,c,d].join(":"))}catch(h){}})},_formatFileSize:function(c){if(typeof c!=="number"){return""}if(c>=1000000000){return(c/1000000000).toFixed(2)+" GB"}if(c>=1000000){return(c/1000000).toFixed(2)+" MB"}return(c/1000).toFixed(2)+" KB"},_formatBitrate:function(c){if(typeof c!=="number"){return""}if(c>=1000000000){return(c/1000000000).toFixed(2)+" Gbit/s"}if(c>=1000000){return(c/1000000).toFixed(2)+" Mbit/s"}if(c>=1000){return(c/1000).toFixed(2)+" kbit/s"}return c.toFixed(2)+" bit/s"},_formatTime:function(d){var c=new Date(d*1000),e=Math.floor(d/86400);e=e?e+"d ":"";return e+("0"+c.getUTCHours()).slice(-2)+":"+("0"+c.getUTCMinutes()).slice(-2)+":"+("0"+c.getUTCSeconds()).slice(-2)},_formatPercentage:function(c){return(c*100).toFixed(2)+" %"},_renderExtendedProgress:function(c){return this._formatBitrate(c.bitrate)+" | "+this._formatTime((c.total-c.loaded)*8/c.bitrate)+" | "+this._formatPercentage(c.loaded/c.total)+" | "+this._formatFileSize(c.loaded)+" / "+this._formatFileSize(c.total)},_renderTemplate:function(e,d){if(!e){return b()}var c=e({files:d,formatFileSize:this._formatFileSize,options:this.options});if(c instanceof b){return c}return b(this.options.templatesContainer).html(c).children()},_renderPreviews:function(c){c.context.find(".preview").each(function(d,e){b(e).append(c.files[d].preview)})},_renderUpload:function(c){return this._renderTemplate(this.options.uploadTemplate,c)},_renderDownload:function(c){return this._renderTemplate(this.options.downloadTemplate,c).find("a[download]").each(this._enableDragToDesktop).end()},_startHandler:function(g){g.preventDefault();var c=b(g.currentTarget),d=c.closest(".template-upload"),f=d.data("data");c.prop("disabled",true);if(f&&f.submit){f.submit()}},_cancelHandler:function(f){f.preventDefault();var c=b(f.currentTarget).closest(".template-upload,.template-download"),d=c.data("data")||{};d.context=d.context||c;if(d.abort){d.abort()}else{d.errorThrown="abort";this._trigger("fail",f,d)}},_deleteHandler:function(d){d.preventDefault();var c=b(d.currentTarget);this._trigger("destroy",d,b.extend({context:c.closest(".template-download"),type:"DELETE"},c.data()))},_forceReflow:function(c){return b.support.transition&&c.length&&c[0].offsetWidth},_transition:function(d){var c=b.Deferred();if(b.support.transition&&d.hasClass("fade")&&d.is(":visible")){d.bind(b.support.transition.end,function(f){if(f.target===d[0]){d.unbind(b.support.transition.end);c.resolveWith(d)}}).toggleClass("in")}else{d.toggleClass("in");c.resolveWith(d)}return c},_initButtonBarEventHandlers:function(){var c=this.element.find(".fileupload-buttonbar"),d=this.options.filesContainer;this._on(c.find(".start"),{click:function(f){f.preventDefault();d.find(".start").click()}});this._on(c.find(".cancel"),{click:function(f){f.preventDefault();d.find(".cancel").click()}});this._on(c.find(".delete"),{click:function(f){f.preventDefault();d.find(".toggle:checked").closest(".template-download").find(".delete").click();c.find(".toggle").prop("checked",false)}});this._on(c.find(".toggle"),{change:function(f){d.find(".toggle").prop("checked",b(f.currentTarget).is(":checked"))}})},_destroyButtonBarEventHandlers:function(){this._off(this.element.find(".fileupload-buttonbar").find(".start, .cancel, .delete"),"click");this._off(this.element.find(".fileupload-buttonbar .toggle"),"change.")},_initEventHandlers:function(){this._super();this._on(this.options.filesContainer,{"click .start":this._startHandler,"click .cancel":this._cancelHandler,"click .delete":this._deleteHandler});this._initButtonBarEventHandlers()},_destroyEventHandlers:function(){this._destroyButtonBarEventHandlers();this._off(this.options.filesContainer,"click");this._super()},_enableFileInputButton:function(){this.element.find(".fileinput-button input").prop("disabled",false).parent().removeClass("disabled")},_disableFileInputButton:function(){this.element.find(".fileinput-button input").prop("disabled",true).parent().addClass("disabled")},_initTemplates:function(){var c=this.options;c.templatesContainer=this.document[0].createElement(c.filesContainer.prop("nodeName"));if(a){if(c.uploadTemplateId){c.uploadTemplate=a(c.uploadTemplateId)}if(c.downloadTemplateId){c.downloadTemplate=a(c.downloadTemplateId)}}},_initFilesContainer:function(){var c=this.options;if(c.filesContainer===undefined){c.filesContainer=this.element.find(".files")}else{if(!(c.filesContainer instanceof b)){c.filesContainer=b(c.filesContainer)}}},_initSpecialOptions:function(){this._super();this._initFilesContainer();this._initTemplates()},_create:function(){this._super();this._resetFinishedDeferreds();if(!b.support.fileInput){this._disableFileInputButton()}},enable:function(){var c=false;if(this.options.disabled){c=true}this._super();if(c){this.element.find("input, button").prop("disabled",false);this._enableFileInputButton()}},disable:function(){if(!this.options.disabled){this.element.find("input, button").prop("disabled",true);this._disableFileInputButton()}this._super()}})}));